(function () {
  function getUrl(params){
    if(!params.domain){
      console.error("请求参数缺少domain");
      return
    }
    let url = params.domain;
    if(params.pathName){
      url+=`/${params.pathName}`
    }
    return url;
  }
  let ajax = {
    // 获取模块项目信息
    getNewestSourceUpdateLog: function (params, cb, failcb) {
      $.ajax({
        url: getUrl(params) + '/sourceUpdateLog/getNewestSourceUpdateLog',
        type: 'GET',
        data: {
          platformVersionId: params.libraryId
        },
        dataType: 'json',
        beforeSend: function (request) {
          request.setRequestHeader('Authorization', params.accessToken);
          request.setRequestHeader('Access', 'Client');
        }
      })
        .done(function (result) {
          cb(result);
        })
        .fail(function (error) {
          failcb(error);
        });
    },
    // 获取登录信息  移除登录获取平台
    findAllClient: function (params, cb, failcb) {
      $.ajax({
        url: getUrl(params) + '/platform/findAllClient',
        type: 'GET',
        dataType: 'json',
        beforeSend: function (request) {
          request.setRequestHeader('Access', 'Client');
          // request.setRequestHeader('Authorization', 'Bearer ' + params.accessToken);
        }
      })
      .done(function (result) {
        cb(result);
      })
      .fail(function (error) {
        console.log(error);
        failcb(error);
      });
    },
    // 获取移除登录后所有的版本、主题、终端
    getDeviceVersionClient: function (params, cb, failcb) {
      $.ajax({
        url: getUrl(params) + '/api/version/getDeviceVersionClient',
        type: 'POST',
        async: false,
        data: {
          platformId: params.platformId
        },
        beforeSend: function (request) {
          request.setRequestHeader('Access', 'Client');
          // request.setRequestHeader('Authorization', params.accessToken);
        },
        dataType: 'json'
      })
      .done(function (result) {
        cb(result);
      })
      .fail(function (error) {
        failcb(error);
      });
    },
    
  };
  window.ajax = ajax;
})();
